<?php

/*-------------------------------------
  Script: Maian Gallery v2.0
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: English language file
--------------------------------------*/

/******************************************************************************************************
 * LANGUAGE FILE - PLEASE READ                                                                        *
 * This is a language file for the Maian Gallery script. Edit it to suit your own preferences.      *
 * DO NOT edit the $lang[] variable names in any way and be careful NOT to remove any of the          *
 * apostrophe`s (') that contain the variable info. This will cause the script to malfunction.        *
 * USING APOSTROPHES IN MESSAGES                                                                      *
 * If you need to use an apostrophe, escape it with a backslash. ie: d\'apostrophe.                   * 
 * SYSTEM VARIABLES                                                                                   *
 * Single letter variables with a percentage sign are system variables. ie: %d, %s {%d} etc                *
 * The system will not fail if you accidentally delete these, but some language may not display       *
 * correctly.                                                                                         *
 ******************************************************************************************************/

/*---------------------------------------------
  CHARACTER SET
  For encoding HTML characters
  Unless specified in language file,
   this may not need altering.
----------------------------------------------*/


$msg_charset               = 'iso-8859-1';


/*------------------------------------
  THEMES/*THEME/HEADER.TPL.PHP
-------------------------------------*/


$msg_header                = 'Online Photo Gallery @ {website}';
$msg_header2               = 'Home';
$msg_header3               = 'Contact';
$msg_header4               = 'About';
$msg_header5               = 'Search';
$msg_header6               = 'picture in Cart';
$msg_header7               = 'pictures in Cart';
$msg_header8               = 'Licence';
$msg_header9               = 'Advanced Search';
$msg_header10              = 'Click to View Cart';
$msg_header11              = 'View';
$msg_header12              = 'Photo Gallery';
$msg_header13              = 'Shopping Cart';
$msg_header14              = 'Categories';
$msg_header15              = 'View Cart';


/*------------------------------------
  THEMES/*THEME/INDEX.TPL.PHP
-------------------------------------*/


$msg_publichome            = 'Most Viewed';
$msg_publichome2           = 'Random Selection';
$msg_publichome3           = 'No Images';
$msg_publichome4           = 'Welcome to my photo gallery, I hope you enjoy browsing my pictures. If you have any questions about any images, please use the contact option on any image page. For general enquries use the contact link in the menu.<br /><br />
                              To begin, please choose a category to view. Thank you!';
$msg_publichome5           = 'There are currently <b>{pics}</b> pictures in <b>{cats}</b> categories, which have been viewed <b>{views}</b> times.<br /><br />Latest image added: <b>{date}</b>';
$msg_publichome6           = 'Latest Pictures';
$msg_publichome7           = '<span class="processed">Order Cancelled!</span>Your order was successfully cancelled and no payment has been sent.<br /><br />
                              Sorry you decided to cancel your purchase and I hope to see you again sometime.<br /><br />
                              <a href="{url}" title="Continue"><b>Continue</b></a> &raquo;
                              ';
$msg_publichome8           = '<span class="processed">Order Complete - Thank You!</span> Thank you for purchasing some pictures. An e-mail has been sent to you to confirm this purchase.<br /><br />
                              Another e-mail will follow when your pictures have been shipped.<br /><br />
                              <a href="{url}" title="Continue"><b>Continue</b></a> &raquo; 
                              ';     
$msg_publichome9           = 'Gallery Picture Purchase';                              
$msg_publichome10          = 'Connecting to Paypal server..<br /><br /><img src="themes/{theme}/images/connecting.gif" alt="Connecting" title="Connecting" /><br /><br />Please wait..';
$msg_publichome11          = 'Stats';


/*------------------------------------
  THEMES/*THEME/ABOUT.TPL.PHP
-------------------------------------*/


$msg_about                 = 'Below you will find some information about this gallery:';


/*------------------------------------
  THEMES/*THEME/ERROR.TPL.PHP
-------------------------------------*/


$msg_error                 = 'A system error has occurred. More details are shown below:';
$msg_error2                = 'Error';


/*------------------------------------
  THEMES/*THEME/LICENCE.TPL.PHP
-------------------------------------*/


$msg_licence               = 'Below you will find some licencing information about the images in this gallery:';


/*------------------------------------
  THEMES/*THEME/ASK_QUESTION.TPL.PHP
-------------------------------------*/


$msg_question              = 'Message Sent!';
$msg_question2             = 'Thanks for enquiring about the above image.<br /><br />A reply will follow as soon as possible!';
$msg_question3             = 'Question About Picture!';
$msg_question4             = 're: {picture}';
$msg_question5             = 're: Question About Picture!';


/*----------------------------------------
  THEMES/*THEME/LEAVE_COMMENT.TPL.PHP
-----------------------------------------*/


$msg_comment               = 'Leave Comment';
$msg_comment2              = 'If you would like to leave a comment for this picture, please use the form below:';
$msg_comment3              = 'Image Preview';
$msg_comment4              = 'Comments are not enabled for this category!';
$msg_comment5              = 'Continue &raquo;';
$msg_comment6              = 'E-Mail (Not Published)';
$msg_comment7              = 'This e-mail is banned...choose another..';
$msg_comment8              = 'E-Mail Verification!';
$msg_comment9              = '<b>E-Mail Verification</b><br /><br />Thanks for posting some comments {name}.<br /><br />Before your comment
                              can be considered for inclusion, you need to verify your e-mail address. Note that you only
                              need to do this once if using the same e-mail address.<br /><br />Please check your inbox at 
                              "{email}" and follow the instructions provided.<br /><br />Thanks!';
$msg_comment10             = '<b>Approval Required</b><br /><br />Thanks for posting {name}.<br /><br />Before your comment can appear it
                              needs to be approved by the webmaster.<br /><br />Confirmation of your post has been sent to you at "{email}".<br /><br />
                              Your comments will be checked shortly.<br /><br />Thanks!'; 
$msg_comment11             = 'New Comments Added!';
$msg_comment12             = 'Thanks for your Comments!';           
$msg_comment13             = '<b>Thank You</b><br /><br />Thanks for posting some comments {name}.<br /><br />Your comments have been added and can be viewed on the page of the image
                              you just left comments for.';                                                
$msg_comment14             = '<p class="return">&lt; <a href="{url}" title="Return">Return to Image Page</a> &gt;</p>';
$msg_comment15             = 'An error has occured when trying to verify your e-mail address. Possible reasons for this are as follows<br /><br />
                              &#8226; You clicked an old link you had bookmarked and this link has expired.<br />
                              &#8226; Your e-mail address has already been verified.<br />
                              &#8226; The link you clicked is incorrect. Check the link in your mail program.<br />
                              &#8226; The comments you entered have already been processed.
                              ';
$msg_comment16             = 'E-Mail Address Successfully Verified!<br /><br />The e-mail address "{email}" has now been added to our list of approved addresses.'; 
$msg_comment17             = '<br /><br />Before your comment can appear it needs to be approved by the webmaster.<br /><br />Confirmation of your post has been sent to you at {email}.<br /><br />
                              Your comments will be checked shortly.<br /><br />Thanks!';                             
$msg_comment18             = '<br /><br />Thanks for posting some comments {name}.<br /><br />Your comments have been added and can be viewed on the page of the image
                              you just left comments for.';


/*------------------------------------
  THEMES/*THEME/CATEGORY.TPL.PHP
-------------------------------------*/


$msg_category              = 'Gallery Category';
$msg_category2             = 'Pictures in this category are shown below. This category may also have sub categories, displayed on the right
                              hand side. Use the buttons provided to view images.';
$msg_category3             = 'Other Categories';
$msg_category4             = 'None to Display';
$msg_category5             = 'Most Popular Pictures in this Category';
$msg_category6             = 'View Slideshow';
$msg_category7             = '{count} Pictures';
$msg_category8             = 'Slideshows are not enabled for this category!';
$msg_category9             = 'Latest Pictures in this Category';
$msg_category10            = 'Last Picture Added: {date}';
$msg_category11            = 'Search Category';
$msg_category12            = 'Other Categories/Information';


/*------------------------------------
  THEMES/*THEME/CONTACT.TPL.PHP
-------------------------------------*/


$msg_contact               = 'If you would like to contact us about our pictures, please use the form below:';
$msg_contact2              = 'All Fields Required. Thank You!';
$msg_contact3              = 'Name';
$msg_contact4              = 'E-Mail';
$msg_contact5              = 'Subject';
$msg_contact6              = 'Comments';
$msg_contact7              = 'Send Message';
$msg_contact8              = 'Security Code';
$msg_contact9              = 'Refresh Captcha';
$msg_contact10             = 'Enter Security Code';
$msg_contact11             = 'Please enter your name..';
$msg_contact12             = 'Invalid e-mail..try again..';
$msg_contact13             = 'Please enter a subject..';
$msg_contact14             = 'Please enter some comments..';
$msg_contact15             = 'Invalid code..try again..';
$msg_contact16             = 'Please correct the {count} errors below:';
$msg_contact17             = '&#8226; Thank you...Your message has been sent...A Reply will follow as soon as possible..';
$msg_contact18             = 're: {subject}';
$msg_contact19             = 'Thank You...Message Sent..';


/*------------------------------------
  THEMES/*THEME/PICTURES.TPL.PHP
-------------------------------------*/


$msg_pictures              = 'Viewing Picture';
$msg_pictures2             = 'Information for the picture you have selected is shown below:';
$msg_pictures3             = 'Image Information';
$msg_pictures4             = 'Comments';
$msg_pictures5             = 'Click Image to View Full Size Picture';
$msg_pictures6             = '<b>Added</b>: {date}';
$msg_pictures7             = '<b>Sizes</b>: {width}px x {height}px';
$msg_pictures8             = '<b>Viewed</b>: {views} times';
$msg_pictures9             = '<b>File Size</b>: {size}';
$msg_pictures10            = 'Have a Question?';
$msg_pictures11            = 'Leave Comment?';
$msg_pictures12            = 'Buy Pictures';
$msg_pictures13            = 'Add to Cart';
$msg_pictures14            = 'Posted by: ';
$msg_pictures15            = 'This image currently has 0 comments.';
$msg_pictures16            = 'Comments are not enabled for this image.';


/*-------------------------------------------
  THEMES/*THEME/SEARCH.TPL.PHP
  THEMES/*THEME/ADVANCED_SEARCH.TPL.PHP
--------------------------------------------*/


$msg_publicsearch          = 'Your search generated <b>0</b> results for "<b>{keywords}</b>".<br />For a more detailed search, seperate keywords with a space or try the advanced search option.
                              <span class="advanced_search">[ <a href="javascript:toggle_box(\'search\')" title="New Search">New Search</a> ]</span>
                              ';
$msg_publicsearch2         = '{count} results found!';
$msg_publicsearch3         = 'Your search results are shown below:';
$msg_publicsearch4         = 'Search generated in <b>{seconds}</b> seconds.';
$msg_publicsearch5         = 'Use the advanced option if you are trying to locate a specific picture and the database contains lots of images. Keywords are required, the other fields optional:';
$msg_publicsearch6         = 'Advanced Search Options';
$msg_publicsearch7         = 'Keywords';
$msg_publicsearch8         = 'Please enter some keywords..';
$msg_publicsearch9         = 'All Categories';
$msg_publicsearch10        = 'Category';
$msg_publicsearch11        = 'Keyword Match';
$msg_publicsearch12        = 'Exact';
$msg_publicsearch13        = 'Partial';
$msg_publicsearch14        = 'Search Areas <span class="normal_italics">(Defaults to both if none selected)</span>';
$msg_publicsearch15        = 'Image Comments (Webmaster)';
$msg_publicsearch16        = 'Image Name';
$msg_publicsearch17        = 'Search';
$msg_publicsearch18        = 'Where Date Added Between';
$msg_publicsearch19        = 'Order By';
$msg_publicsearch20        = 'Oldest';
$msg_publicsearch21        = 'Newest';
$msg_publicsearch22        = 'Name';
$msg_publicsearch23        = 'Search Results';
$msg_publicsearch24        = 'Specify Search Options';


/*------------------------------------
  THEMES/*THEME/SLIDESHOW.TPL.PHP
-------------------------------------*/


$msg_slideshow             = 'Slideshow';
$msg_slideshow2            = 'utf-8';
$msg_slideshow3            = 'Please be patient while the images are loading:';
$msg_slideshow4            = 'Loading..';
$msg_slideshow5            = 'Select Picture';
$msg_slideshow6            = 'Slow';
$msg_slideshow7            = 'Fast';
$msg_slideshow8            = 'Faster';


/*----------------------------------------
  THEMES/*THEME/VIEW_CART.TPL.PHP
-----------------------------------------*/


$msg_viewcart              = 'Your shopping cart is shown below. Update quantities where necessary or use the buttons to remove pictures. Setting a quantity to 0 will also remove an item. Once you are happy with your cart selections, click the checkout button.';
$msg_viewcart2             = 'Your shopping cart is currently empty!';
$msg_viewcart3             = 'Size: {size}';
$msg_viewcart4             = 'Item No: {itemno}';
$msg_viewcart5             = 'Qty';
$msg_viewcart6             = 'Delete Item';
$msg_viewcart7             = 'Total';
$msg_viewcart8             = 'Clear Cart';
$msg_viewcart9             = 'Update Cart';
$msg_viewcart10            = 'Checkout';
$msg_viewcart11            = 'Shipping Charge';
$msg_viewcart12            = 'Viewing Shopping Cart';
$msg_viewcart13            = 'Cart Contents';


/*--------------------
  ADMIN/INC/HEADER.PHP
---------------------*/


$msg_adminmenu             = 'OPTIONS';
$msg_adminmenu2            = 'Home';
$msg_adminmenu3            = 'Settings';
$msg_adminmenu4            = 'Categories';
$msg_adminmenu5            = 'Search Images';
$msg_adminmenu6            = 'Add Images';
$msg_adminmenu7            = 'Manage Images';
$msg_adminmenu8            = 'Home';
$msg_adminmenu9            = 'Support';
$msg_adminmenu10           = 'Menu';
$msg_adminmenu11           = 'Adminstration';
$msg_adminmenu12           = 'View Sales';
$msg_adminmenu13           = 'Logout';
$msg_adminmenu14           = 'Approve Comments';
$msg_adminmenu15           = 'Selling Options';
$msg_adminmenu16           = 'Ban Options';
$msg_adminmenu17           = 'E-Mail Addresses';
$msg_adminmenu18           = 'Search Sales';


/*-------------------------------------------------------
  ADMIN/DATA_FILES/IMAGE_MANAGEMENT/ADD_IMAGES.PHP
  ADMIN/DATA_FILES/POPUP/EDIT_IMAGE.PHP
---------------------------------------------------------*/


$msg_addimg                = 'To add images, first upload them into the <b>\'galleries/new/\'</b> directory and then refresh this page. If auto thumbnail generation is enabled in your settings, thumbs will be created automatically. If it is disabled, an option will appear below to upload the thumbnail. Bitmap files can be added, but are not supported for auto thumbnail creation.<br><br>Supported files for auto resize: <b>.jpg | .jpeg | .gif | .png</b>';
$msg_addimg2               = 'New Images';
$msg_addimg3               = 'Re-Load as Category';
$msg_addimg4               = 'Required';
$msg_addimg5               = 'No new images present. Please add new images to "<b>galleries/new/</b>" directory then refresh page.';
$msg_addimg6               = 'Sale Item';
$msg_addimg7               = 'Name';
$msg_addimg8               = 'Thumbnail';
$msg_addimg9               = 'Category';
$msg_addimg10              = 'Event';
$msg_addimg11              = 'Comments';
$msg_addimg12              = 'Add New Images';
$msg_addimg13              = 'Image Report';
$msg_addimg14              = 'Optional';
$msg_addimg15              = 'Details';
$msg_addimg16              = 'A report of the images you have added is shown below:';
$msg_addimg17              = 'Re-Load Previous Page';
$msg_addimg18              = 'Support for the <a href="http://www.php.net/gd" target="_blank"><b>GD2 Graphics Library</b></a> does <b>not</b> appear to be enabled on your server.<br><br>Please enable this in your PHP.ini file before you continue or disable the auto thumbnail option in your settings.<br><br>Contact your host in you are not sure of this feature.';
$msg_addimg19              = 'Status';
$msg_addimg20              = 'Image Successfully Added!';
$msg_addimg21              = 'Thumbnail could not be created. Check directories are writeable as per the documentation!';
$msg_addimg22              = 'Thumbnail could not be uploaded. Check "{dir}" is writeable and file was valid image file!';
$msg_addimg23              = 'Cost<br>Size<br>Item No';
$msg_addimg24              = 'Sale Help';
$msg_addimg25              = 'If you are selling images and have chosen an image as a sale item, this script enables you to sell different images at different sizes.<br><br>
                              In the \'Details\' box, you need to specify the cost, size &amp; item number for your item. Each option <b>MUST</b> be seperated with a pipe (|). For multiple sizes, add one per line. For prices, <b>NO</b> symbol is required. Note that the order is important.<br><br>
                              Example:<br><br>1.99<b>|</b>8x6<b>|</b>item1234<br>2.99<b>|</b>10x12<b>|</b>item3456<br>3.99<b>|</b>14x18<b>|</b>item7890<br><br>
                              <b>All the images the same attributes?</b><br><br>To save time, you can batch update selling options by using the "Selling Options" link from the drop down menu. This is useful if you have a lot of pictures in a category and all
                              those pictures have the same attributes for sales. If you want to use this feature, leave the selling options blank when adding images.
                              ';
$msg_addimg26              = 'Thumbnail could not be moved! Check directory "{dir}" is writeable and try again!';
$msg_addimg27              = 'Database error when inserting data. Check and try again!';  
$msg_addimg28              = 'Visits';                            
$msg_addimg29              = 'Update Image';
$msg_addimg30              = '<b>Image Updated!</b><br><br>This image has been successully updated!';
$msg_addimg31              = 'Re-Edit';
$msg_addimg32              = '"{dir}" image directory does not exist. Please create manually and try again!';
$msg_addimg33              = 'Enable Image';
$msg_addimg34              = 'If updated, move image manually';


/*------------------------------
  ADMIN/DATA_FILES/CATS.PHP
-------------------------------*/


$msg_cats                  = 'Manage gallery categories below. Before images can be added, categories must be created. Categories can be a new parent category or a sub category of a current parent category. Slideshows, comments and watermarks can be disabled for any category, providing the options are active
                              in the settings. If you wish to enable a category after you have added images, leave the boxed unchecked for enabling the category.';
$msg_cats2                 = 'New Category';
$msg_cats3                 = 'Add New Category';
$msg_cats4                 = 'There are currently <b>0</b> categories in the database.';
$msg_cats5                 = 'Manage Categories';
$msg_cats6                 = 'Enable Options';
$msg_cats7                 = 'Comments';
$msg_cats8                 = 'Slideshow';
$msg_cats9                 = 'Watermarks';
$msg_cats10                = 'Update Category';
$msg_cats11                = '<b>{count}</b> image(s) deleted!<br><br>';
$msg_cats12                = 'Category Type';
$msg_cats13                = 'Parent Category';
$msg_cats14                = 'Child category of';
$msg_cats15                = 'Click name to edit';
$msg_cats16                = 'Delete Child Category';
$msg_cats17                = 'Remove Selected Categories';
$msg_cats18                = 'No Parent Categories';
$msg_cats19                = 'Category Image Folder';
$msg_cats20                = 'Meta Keywords';
$msg_cats21                = 'Meta Description';
$msg_cats22                = 'Slideshow Music (.mp3)';
$msg_cats23                = 'Category';


/*--------------------------------------------
  ADMIN/DATA_FILES/COMMENTS.PHP
  ADMIN/DATA_FILES/POPUP/VIEW_COMMENTS.PHP
  ADMIN/DATA_FILES/POPUP/COMMENTS.PHP
---------------------------------------------*/


$msg_comments              = 'Approve Comments';
$msg_comments2             = 'This page shows comments that are queued for approval. Use the links provided to view comments. Use the checkboxes to batch approve or reject comments. Check the notification box if you want your visitor to be notified if their entry has been approved or rejected.';
$msg_comments3             = '{count} comments';
$msg_comments4             = 'There are currently <b>0</b> comments queued for approval or this feature is disabled';
$msg_comments5             = 'View';
$msg_comments6             = 'From';
$msg_comments7             = 'On';
$msg_comments8             = 'Process Selected Entries';
$msg_comments9             = 'Approve';
$msg_comments10            = 'Reject';
$msg_comments11            = 'Notification E-Mail';
$msg_comments12            = 'Update Comments';
$msg_comments13            = 'Comments left by <b>{name}</b> on <b>{date}</b>';
$msg_comments14            = 'This image currently has <b>0</b> comments in the database';
$msg_comments15            = 'Delete Comments';
$msg_comments16            = 'Updating..';
$msg_comments17            = 'Comments Approved!';
$msg_comments18            = 'Comments Rejected!';


/*--------------------------------------
  ADMIN/DATA_FILES/EMAIL_ADDRESSES.PHP
---------------------------------------*/


$msg_emails                = 'Here you can view e-mail addresses that have been verified when visitors have left comments. Add a new e-mail address to bypass the verification system if enabled:';
$msg_emails2               = 'Add New E-Mail Address';
$msg_emails3               = 'Current Verified E-Mail Addresses';
$msg_emails4               = 'There are currently 0 verified e-mail addresses or this feature is disabled!';
$msg_emails5               = 'Import to CSV';
$msg_emails6               = 'Remove Selected Addresses';
$msg_emails7               = 'Clear All';


/*--------------------------------------
  ADMIN/DATA_FILES/BAN.PHP
---------------------------------------*/


$msg_ban                   = 'Here you can ban ip addresses from accessing your system or e-mail addresses from leaving comments. Note that wildcard ip addresses must always end with a dot or period symbol.<br /><br />Wildcards:<br /><br /><i>*hotmail.com - Bans all e-mail addresses that end in this domain.<br /><br />*123. or *123.45. - Bans all ip addresses that contain these numbers.</i>';
$msg_ban2                  = 'Enter Data';
$msg_ban3                  = 'Currently Banned';
$msg_ban4                  = 'There are currently 0 banned items!';
$msg_ban5                  = 'Import to CSV';
$msg_ban6                  = 'Remove Selected Items';
$msg_ban7                  = 'Clear All';
$msg_ban8                  = 'E-Mail or IP Address';
$msg_ban9                  = 'Ban Address';
$msg_ban10                 = 'Wildcard';
$msg_ban11                 = 'E-Mail';
$msg_ban12                 = 'IP';
$msg_ban13                 = 'All';


/*-----------------------------
  ADMIN/DATA_FILES/HOME.PHP
------------------------------*/


$msg_home                  = '<b>WARNING!</b><br><br>Please remove the "/install/" folder from your installation directory or rename it.';
$msg_home2                 = 'Welcome to Maian Gallery, a free PHP gallery cart system that enables you to add an image gallery to your website and optionally sell your pictures. 
                              For details on how to get started with your gallery system, please see the <a href="../docs/setup/index.html" target="_blank" title="Documentation">documentation</a>. 
                              If you have any problems, please use the support link top left.
                              ';
$msg_home3                 = 'Hope you enjoy this script';
$msg_home4                 = 'Overview';
$msg_home5                 = 'Donations';
$msg_home6                 = 'If you like this script and would like to send a small donation as a token of appreciation, please click the following link';
$msg_home7                 = 'Donations are not necessary, but help towards to continued development of Maian Gallery.';
$msg_home8                 = 'Total Images: <b>{images}</b> in <b>{cats}</b> parent/child categories.<br>
                              Comments Awaiting Approval: <b>{comments}</b><br><br>
                              <b>Top 5 Most Viewed Images</b>
                              ';
$msg_home9                 = 'Latest {count} Comments';   
$msg_home10                = 'The comment system is not currently enabled!';  
$msg_home11                = 'There are currently no comments to display';  
$msg_home12                = 'You have processed <b>{count}</b> sales. Total: <b>{total}</b> / Fees: <b>{fees}</b>';                       


/*-----------------------------
  ADMIN/DATA_FILES/LOGIN.PHP
-------------------------------*/


$msg_adminlogin            = 'Administration Login';
$msg_adminlogin2           = 'Username';
$msg_adminlogin3           = 'Password';
$msg_adminlogin4           = 'Remember Me';
$msg_adminlogin5           = 'Login';
$msg_adminlogin6           = 'Invalid username. Please try again.';
$msg_adminlogin7           = 'Invalid password. Please try again.';
$msg_adminlogin8           = 'Log in to your administration area below:';


/*--------------------------------------
  ADMIN/DATA_FILES/IMAGE_MANAGEMENT/*
---------------------------------------*/


$msg_manage                = 'Please select a category from below to edit images in that category:';
$msg_manage2               = 'Category Name';
$msg_manage3               = 'Total Images';
$msg_manage4               = 'Edit Images';
$msg_manage5               = 'There are currently <b>0</b> images in this category.';
$msg_manage6               = 'Viewing Images';
$msg_manage7               = 'Remove Selected Images';
$msg_manage8               = 'Return to Categories';
$msg_manage9               = 'Categories';
$msg_manage10              = 'Images in this category are shown below. Click an image name to edit image and use the checkboxes to remove images. Remember to move image to new directory if changing category. Click a thumbnail to view the full size image:';
$msg_manage11              = 'Comments';


/*----------------------------------------
  ADMIN/DATA_FILES/SALES.PHP
  ADMIN/DATA_FILES/POPUP/CHANGE_STATUS.PHP
  ADMIN/DATA_FILES/POPUP/VIEW_ORDER.PHP
-----------------------------------------*/


$msg_sales                 = 'Listed below are your picture sale transactions. Only completed transactions are show here. Pending payments from Paypal will log once they clear. Use the buttons provided to manage your sales:';
$msg_sales2                = 'Sales Overview';
$msg_sales3                = 'There are currently <b>0</b> sales to view.';
$msg_sales4                = 'Remove Selected Sales';
$msg_sales5                = 'Change Status';
$msg_sales6                = 'View Order';
$msg_sales7                = 'Buyer';
$msg_sales8                = 'Pictures';
$msg_sales9                = 'Total / Fee / Shipping';
$msg_sales10               = 'Order Status';
$msg_sales11               = 'Order Date / Invoice';
$msg_sales12               = 'Pending';
$msg_sales13               = 'Shipped';
$msg_sales14               = 'Refunded';
$msg_sales15               = 'Change Order Status';
$msg_sales16               = 'Current Status';
$msg_sales17               = 'Update';
$msg_sales18               = 'Send E-Mail to Buyer';
$msg_sales19               = 'Comments (Only required if sending e-mail)';
$msg_sales20               = 'Order Status Updated! (<a href="index.php?cmd=sales&status={id}" title="Refresh">Refresh</a>)';
$msg_sales21               = 'Order Status Updated!';
$msg_sales22               = 'No comments provided';
$msg_sales23               = 'View Order';
$msg_sales24               = 'Paypal Transaction ID';
$msg_sales25               = 'Details';
$msg_sales26               = 'Delivery To';
$msg_sales27               = 'Buyer Memo';
$msg_sales28               = 'N/A';
$msg_sales29               = 'Order Total';
$msg_sales30               = 'inc shipping @';
$msg_sales32               = 'Qty Ordered';
$msg_sales33               = 'Size';
$msg_sales34               = 'Item No';
$msg_sales35               = 'Total';
$msg_sales36               = '@ {price} each';
$msg_sales37               = 'Free Shipping';


/*--------------------------------
  ADMIN/DATA_FILES/SEARCHSALES.PHP
---------------------------------*/


$msg_searchsales           = 'Here you can search your picture sales. In the keywords field enter something relevant to the transaction(s) you are trying to find. ie: invoice no, transaction id, buyer name, buyer e-mail etc. or you can enter the date range for the search. At least one search option is required.';
$msg_searchsales2          = 'Sales Added Between';
$msg_searchsales3          = 'Your search results are shown below. Use the links to manage these sales or use the link to perform a new search:';


/*-----------------------------
  ADMIN/DATA_FILES/SEARCH.PHP
------------------------------*/


$msg_search                = 'Here you can search your image database. Enter one or more of the search options below. For a more detailed search, seperate keywords with a space.';
$msg_search2               = 'Enter Keywords';
$msg_search3               = 'Category';
$msg_search4               = 'Added Between';
$msg_search5               = 'Your search generated <b>0</b> results, please try again..';
$msg_search6               = 'Search Results';
$msg_search7               = 'New Search';
$msg_search8               = 'Enter Search Data';
$msg_search9               = 'Your search results are shown below. Click a thumbnail to view the full size image and the image name to edit.';
$msg_search10              = '{count} Result(s) Found';


/*-----------------------------------------
  ADMIN/DATA_FILES/SELLING_OPTIONS.PHP
------------------------------------------*/


$msg_sellingoptions        = 'Selling Options';
$msg_sellingoptions2       = 'If you are selling your pictures and you have a lot of pictures in a category with the same pricing options, you can batch update them here. Specify your criteria below for batch updating:';
$msg_sellingoptions3       = 'Enter sale information';
$msg_sellingoptions4       = 'Cost|Size|Item No';
$msg_sellingoptions5       = 'Update Sale Options';
$msg_sellingoptions6       = '<b>{count}</b> image sale options updated in selected category!';


/*-----------------------------
  ADMIN/DATA_FILES/SETTINGS.PHP
------------------------------*/


$msg_settings              = 'General';
$msg_settings2             = 'Website Name';
$msg_settings3             = 'Type in the <a href="http://en.wikipedia.org/wiki/Web_colors" target="_blank">hex</a> code below to get the RGB value for that colour.<br><br><b>Example: #000000 = 00-00-00';
$msg_settings4             = 'E-Mail Address';
$msg_settings5             = 'Homepage URL';
$msg_settings6             = 'Folder Path';
$msg_settings7             = 'PHP Date Format';
$msg_settings8             = 'Language';
$msg_settings9             = '<a href="http://en.wikipedia.org/wiki/HTML" title="Hypertext Markup Language" target="_blank">HTML</a> is allowed';
$msg_settings10            = 'Thumbnails Per Page';
$msg_settings11            = 'Update';
$msg_settings12            = 'Image Options';
$msg_settings13            = 'Auto Thumbnail';
$msg_settings14            = 'Auto Thumbnail Sizes';
$msg_settings15            = 'Thumbnail Display Sizes';
$msg_settings16            = 'Settings Updated!';
$msg_settings17            = 'Update your program settings below by selecting the appropriate tabs. For help use the [<b>?</b>] links next to some of the options. Note that some fields will revert to default values if left blank.';
$msg_settings18            = 'Images/Comments/Slideshow';
$msg_settings19            = 'Watermarks';
$msg_settings20            = 'Shopping Cart';
$msg_settings21            = 'SMTP';
$msg_settings22            = 'MySQL Date Format';
$msg_settings23            = 'Enable Shopping Cart';
$msg_settings24            = 'Image Functions';
$msg_settings25            = 'About Page Text';
$msg_settings26            = 'Paypal Page Style';
$msg_settings27            = 'Account E-Mail Address';
$msg_settings28            = 'Enable Test Mode (Sandbox)';
$msg_settings29            = 'Update IPN Settings';
$msg_settings30            = 'Thanks Page URL';
$msg_settings31            = 'Cancel Page URL';
$msg_settings32            = 'Enable Error Logging';
$msg_settings33            = 'Shopping Cart';
$msg_settings34            = 'Watermark Settings';
$msg_settings35            = 'Enable Watermarks';
$msg_settings36            = 'Watermark Text';
$msg_settings37            = 'Watermark Spacing';
$msg_settings38            = 'Vertical';
$msg_settings39            = 'Horizontal';
$msg_settings40            = 'Font Type';
$msg_settings41            = 'Font Size';
$msg_settings42            = 'Text Angle';
$msg_settings43            = 'Degrees';
$msg_settings44            = 'Text Colour';
$msg_settings45            = 'View Sample Watermark';
$msg_settings46            = 'RGB/Hex Colour Converter';
$msg_settings47            = 'Hex Code';
$msg_settings48            = 'Theme';
$msg_settings49            = 'Enable Mod_Rewrite';
$msg_settings50            = 'Here you can set the image/comments &amp; slideshow preferences for your gallery.';
$msg_settings51            = 'Enable Comments';
$msg_settings52            = 'Enable Slideshow';
$msg_settings53            = 'Currency';
$msg_settings54            = 'Reset Image Visit Counts';
$msg_settings55            = 'Image Folder Name';
$msg_settings56            = 'Approve Comments';
$msg_settings57            = 'E-Mail Verification';
$msg_settings58            = 'If you are selling images, you may want to add a watermark to full size previews. Update watermarks settings below. Flash files are not supported and watermarks can be category specific. Save changes before previewing.';
$msg_settings59            = 'Arial';
$msg_settings60            = 'Times New Roman';
$msg_settings61            = 'Verdana';
$msg_settings62            = 'Enable this if you want to sell images. Note that for this to work correctly, your server must have CURL support installed and you must have a Paypal premier or business account. If someone buys pictures they are NOT sent a download link. This system is more for photographers who want to ship or e-mail high quality prints.';
$msg_settings63            = 'Enable SMTP if your server requires authentication to send e-mails. If the mail is being sent ok, there is no need to enable this. If you are unsure of your SMTP details, contact your web hosting company.';
$msg_settings64            = 'Enable SMTP';
$msg_settings65            = 'SMTP Host';
$msg_settings66            = 'SMTP Username';
$msg_settings67            = 'SMTP Password';
$msg_settings68            = 'SMTP Port';
$msg_settings69            = 'Fullsize Image Display Sizes';
$msg_settings70            = 'Reset';
$msg_settings71            = 'Comments Options';
$msg_settings72            = 'Slideshow Options';
$msg_settings73            = 'Slideshow Window Size';
$msg_settings74            = 'Enable Captcha';
$msg_settings75            = 'Licence Text';
$msg_settings76            = 'Image Display Width on Page';
$msg_settings77            = 'Full Size Window Sizes';
$msg_settings78            = 'Default Meta Keywords';
$msg_settings79            = 'Default Meta Description';
$msg_settings80            = 'Enable Theme Switcher';
$msg_settings81            = 'Enable SSL';
$msg_settings82            = 'Background Music (.mp3)';
$msg_settings83            = 'Slideshow Speeds';
$msg_settings84            = 'None';
$msg_settings85            = 'Shipping Options';
$msg_settings86            = 'Set Rate';
$msg_settings87            = 'Per Picture';
$msg_settings88            = 'Comments Per Page';
$msg_settings89            = 'Order Comments By';
$msg_settings90            = 'Newest Comment';
$msg_settings91            = 'Oldest Comment';


/*-----------------
  GENERAL VARIABLES
------------------*/


$msg_script                = 'Maian Gallery';
$msg_script2               = 'v2.0';
$msg_script3               = 'Powered by';
$msg_script4               = 'Template by';
$msg_script5               = 'Yes';
$msg_script6               = 'No';
$msg_script7               = 'Administration';
$msg_script8               = 'Pages';
$msg_script9               = 'First Page';
$msg_script10              = 'Last Page';
$msg_script11              = 'An Error Has Occured';
$msg_script12              = 'Return to Previous Page';
$msg_script13              = 'Close Window';
$msg_script14              = 'Max';
$msg_script15              = 'Chars';
$msg_script16              = 'Edit';
$msg_script17              = 'Delete';
$msg_script18              = 'ACCESS DENIED!';
$msg_script19              = 'You do not have permission to view the selected directory.';
$msg_script20              = 'Error';
$msg_script21              = 'Refresh Page';
$msg_script22              = 'The following errors have occured:';
$msg_script23              = 'Continue';
$msg_script24              = 'of';
$msg_script25              = 'Back to Top';
$msg_script26              = 'Support';
$msg_script27              = 'Change Theme';
$msg_script28              = 'Cancel';
$msg_script29              = 'Print';
$msg_script30              = 'Copyright';
$msg_script31              = 'All Rights Reserved';
$msg_script32              = 'Test';
$msg_script33              = 'Your IP address is not permitted to access our system.<br /><br />If you would like to contact us about this issue, use the contact link in the menu. Thank you!';
$msg_script34              = 'Bytes';


/*----------------------
  ADMIN/INC/CALENDAR.PHP
-----------------------*/


$msg_calendar              = 'January';
$msg_calendar2             = 'February';
$msg_calendar3             = 'March';
$msg_calendar4             = 'April';
$msg_calendar5             = 'May';
$msg_calendar6             = 'June';
$msg_calendar7             = 'July';
$msg_calendar8             = 'August';
$msg_calendar9             = 'September';
$msg_calendar10            = 'October';
$msg_calendar11            = 'November';
$msg_calendar12            = 'December';


/*-----------------------------
  RSS Feeds
-------------------------------*/


$msg_rss                   = 'Latest pictures @ {website_name}';
$msg_rss2                  = 'These are the latest pictures to be added at {website_name}';
$msg_rss3                  = 'Picture: ';


/*-----------------------
  IPN VARS
-------------------------*/


$msg_ipn                   = 'The following input was received from (and sent back to) PayPal:';
$msg_ipn2                  = 'Paypal IPN Error!';
$msg_ipn3                  = 'Payment Pending - Please Read!';
$msg_ipn4                  = 'Thank you for your Order!';
$msg_ipn5                  = 'Gallery Order Complete!';
$msg_ipn6                  = 'Size';
$msg_ipn7                  = 'Cost';
$msg_ipn8                  = 'Qty';


/*-----------------------------------------------------------------------------------------------------
  JAVASCRIPT VARIABLES
  IMPORTANT: If you want to use apostrophes in these variables, you MUST escape them with 3 backslashes
             Failure to do this will result in the script malfunctioning on javascript code.
  EXAMPLE: d"apostrophe
  
  Double quotes will be fine as they will be converted to character entities
------------------------------------------------------------------------------------------------------*/


$msg_javascript            = 'Are you sure?';
$msg_javascript2           = 'Help/Information';
$msg_javascript3           = 'URL to folder containing gallery script. NO trailing slash at the end.<br><br><b>http://www.yoursite.com/gallery</b>';
$msg_javascript4           = 'PHP Date Format. Date displays if cart is disabled. If you are unsure, don`t change. <a href="http://www.php.net/date" target="_blank"><b>Info</b></a>';
$msg_javascript5           = 'Enable this option for search engine friendly urls. Your server must support .htaccess. See the docs for more information.';
$msg_javascript6           = 'Size for slideshow pop up window. Width and Height seperated with a comma. ie: <b>640,480</b>';
$msg_javascript7           = 'Specify the amount of thumbnails to show per page. <b>1 - 999 ONLY</b>';
$msg_javascript8           = 'Enable this feature for the script to auto create thumbnail images. Disable this feature to update thumbnails manually.';
$msg_javascript9           = 'Specify size for auto thumbnail creation. Note that aspect ratio is maintained when creating thumbnails.';
$msg_javascript10          = 'Display size for thumbnails. Displays thumbnails at the same size if enabled. This is useful if the auto thumbnail created some thumbnails at a different size.<br><br>Set to 0 to disable and display thumbnails at exact size or have the size controlled via the stylesheet.';
$msg_javascript11          = 'This is an alternative method for viewing full size images. <br><br>If disabled, full size images display in a popup.<br><br>Note that the greybox option is preferred as some browsers may block popups.';
$msg_javascript12          = 'This will keep you logged in for 30 days.<br><br><b>NOT</b> recommended for shared computers.<br><br>Cookies MUST be enabled.';
$msg_javascript13          = 'This is the MySQL date format. Converts <b>YYYY-MM-DD</b> database output. <a href="http://dev.mysql.com/doc/refman/5.0/en/date-and-time-functions.html" target="_blank"><b>Info</b></a><br>';
$msg_javascript14          = 'No More Information';
$msg_javascript15          = 'Are you sure you want to delete %d?\n\nThis will clear all data associated with this member including sent cards and file uploads.';
$msg_javascript16          = 'Display size for full size image when viewed in pop up window. Displays images at the same size if enabled. This is useful if you have images that are very large.<br><br>Set to 0 to disable and display images at exact size.';
$msg_javascript17          = '\n\nWARNING!\n\nThis will also delete %d images attached to this category!';
$msg_javascript18          = 'Max image width for slideshow images. Must be greater than 0.';
$msg_javascript19          = 'This is your Paypal premier or business account e-mail address. If using Sandbox, this is your Sandbox test e-mail address.';
$msg_javascript20          = 'If enabled, visitors can comment on images. Comments can be category specific.';
$msg_javascript21          = 'If enabled, comments require webmaster approval before appearing on your website.';
$msg_javascript22          = 'If error logging is on, invalid transactions get logged and an e-mail gets sent to the webmaster detailing Paypal`s response.';
$msg_javascript23          = 'Paypal lets you create a page design style. If you have one, specify its name here, otherwise leave blank.';
$msg_javascript24          = 'Do you wish to enable the sandbox system? <a href="https://developer.paypal.com" target="_blank"><b>Sandbox Testing</b></a>';
$msg_javascript25          = 'Transaction cost. Numeric value with or without period (.) symbol. ie: 9, 9.99';
$msg_javascript26          = 'If you check this box and update your settings, all image visit counts will be reset to 0. For individual images, use the "Manage Images" option.';
$msg_javascript27          = 'If you are selling images it is recommended you change the name of the "galleries/<b>categories</b>/" folder to something unique. Rename the folder manually and specify its name here.';
$msg_javascript28          = 'If enabled and comments are added, the visitor must verify their e-mail address before the comment gets submitted. This can be enabled along with the approve function. E-mails require verification once only.';
$msg_javascript29          = 'If enabled, visitors can view your images in a slideshow. Slideshows can be category specific.';
$msg_javascript30          = 'Delete Child Category\n\nAre You Sure?\n\nImages and image folder should be removed manually';
$msg_javascript31          = 'Delete Selected Categories\n\nAre You Sure?\n\nThis will also clear Child Categories\n\nImages and image folder should be removed manually';
$msg_javascript32          = 'This is the folder where the images exist for this category. This category should be in the main folder specified in your settings. For example, if you have a category called "Flowers", create a folder called "flowers" inside the main folder and specify "flowers" here. For a child category, place the child inside the parent. ie: "flowers/child" and specify "flowers/child" here. NO trailing slash. See the docs for more information.';
$msg_javascript33          = 'Delete Selected Images\n\nAre You Sure?';
$msg_javascript34          = 'Please be patient while images are being processed..\n\nTo continue click OK.';
$msg_javascript35          = 'Updating all image sale options in selected category\n\nAre You Sure?';
$msg_javascript36          = 'Process Selected Comments\n\nAre You Sure?';
$msg_javascript37          = 'Delete Comments\n\nAre You Sure?';
$msg_javascript38          = 'Set 3 speeds for the slideshow in milliseconds. Slow,Fast,Faster. Seperate each with a comma. ie: <b>9000,12000,15000</b><br /><br/>See the docs for how to enable the default speed.';
$msg_javascript39          = 'This option lets you apply a set rate shipping charge to your cart total. Set to 0 for no shipping rate. No currency symbol for price.';
$msg_javascript40          = 'This option lets you apply a set rate shipping charge to a single picture. This would apply to all pictures. Set to 0 for no shipping rate. Note that this option overwrites the set rate. No currency symbol for price';
$msg_javascript41          = 'How many comments do you want to display per page? Max 999.';
$msg_javascript42          = 'Enable the image captcha code to help prevent spam from being submitted in your forms. The GD graphic library must be installed on your server for this to work.';
$msg_javascript43          = 'This is the display width for an image when it initially loads on the page. Height is auto calculated by the script.';
$msg_javascript44          = 'Specify sizes for pop up window that loads the full size image. Width and height seperated with a comma. ie: <b>640,480</b>';
$msg_javascript45          = 'Used by search engines. Specify default keywords for gallery. Can be overwritten for categories and images.';
$msg_javascript46          = 'Used by search engines. Specify default description for gallery. Can be overwritten for categories and images.';
$msg_javascript47          = 'Used by search engines. Specify keywords for category. Leave blank to be overwritten by default in settings if specified.';
$msg_javascript48          = 'Used by search engines. Specify description for category. Leave blank to be overwritten by default in settings if specified.';
$msg_javascript49          = 'Used by search engines. Specify keywords for image. Leave blank to be overwritten by category keywords or default in settings if specified.';
$msg_javascript50          = 'Used by search engines. Specify description for image. Leave blank to be overwritten by category description or default in settings if specified.';
$msg_javascript51          = 'If you have SSL enabled, enable this to send the paypal data back to your secure area. Do not enable this if you have no SSL installed.';
$msg_javascript52          = 'If you have more than one theme and you want visitors to switch between themes, enable this option. A select box will appear at the base of your gallery.';
$msg_javascript53          = 'This is optional and lets you have background music for your slideshow. This is the default file. If adding new file, it must be .mp3 format and be located in the "mp3" folder.<br /><br />Background music can be category specific.';
$msg_javascript54          = 'Specify background music for this category if you want the music to be different from the default. If adding new file, it must be .mp3 format and be located in the "mp3" folder.';
$msg_javascript55          = 'How should comments be ordered? Newest has latest comment at the top, Oldest has latest comment at the bottom.';

// For advanced search javascript calendar...
// Seperate values with a comma and enclose in apostrophes..
// Escape apostrophes with a slash. "'Su','Mo\'n', etc
$msg_javascript56          = "'Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'";
$msg_javascript57          = "'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'";
$msg_javascript58          = "'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'";
$msg_javascript59          = "'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'";
$msg_javascript60          = "'Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', 'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'";
$msg_javascript61          = "'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'";
$msg_javascript62          = 'This Month'; 
$msg_javascript63          = 'Close'; 
 
?>
